/*
 * This file is part of PAXLink, which is an AI for OpenTTD
 * Copyright (C) 2008  Leif Linse
 *
 * PAXLink is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * PAXLink is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PAXLink; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

// min OpenTTD nightly: 2009-01-18

class PAXLink extends AIInfo {
	function GetAuthor()      { return "Zuu"; }
	function GetName()        { return "PAXLink"; }
	function GetShortName()            { return "PAXL"; }
	function GetDescription() { return "PAXLink transport passengers with buses and airplanes. Airplanes are used for inter city transport and buses for feeding the airports with passengers."; }
	function GetAPIVersion()  { return "1.0"; }
	function GetVersion()     { return 14; }
	function GetDate()        { return "2010-02-20"; }
	function GetUrl()         { return "http://www.tt-forums.net/viewtopic.php?f=65&t=41518"; }
	function UseAsRandomAI()  { return true; }
	function CreateInstance() { return "PAXLink"; }
	
	function MinVersionToLoad() { return 1; }

	function GetSettings() {
		AddSetting({name = "avoid_town_road_grid", description = "Avoid building bus stops and depots on town road grid", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});
		AddSetting({name = "forbid_town_road_grid", description = "Forbid building bus stops and depots on town road grid", easy_value = 1, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});

		AddSetting({name = "use_conditional_orders", description = "Use conditional orders", easy_value = 0, medium_value = 1, hard_value = 1, custom_value = 1, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});
		AddSetting({name = "use_ap_pair_optimizer", description = "Run airport pair optimizer annually (experimental feature)", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});

		AddSetting({name = "debug_signs", description = "Enable building debug signs", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});
		AddSetting({name = "clear_signs", description = "Clear all debug signs (from time to time)", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});
		AddSetting({name = "quit_on_api_check_failure", description = "Quit if OpenTTD API check fails (highly recommended!)", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = AICONFIG_BOOLEAN});
	}

}

/* Tell the core we are an AI */
RegisterAI(PAXLink());
