﻿//Expensive things to do. Some of them are useless, others may be useful

function RailwAI::RaiseLandOfRailSlopes() {
	foreach (tile in this.myTiles) {
		if (AIRail.IsRailTile(tile) && AITile.GetSlope(tile) != AITile.SLOPE_FLAT) {
			local tracks = AIRail.GetRailTracks(tile)
			local slope = AITile.GetSlope(tile)
			if (tracks == AIRail.RAILTRACK_NE_SW || tracks == AIRail.RAILTRACK_NW_SE) {
				if (slope == AITile.SLOPE_N || slope == AITile.SLOPE_W || slope == AITile.SLOPE_S || slope == AITile.SLOPE_E) {
					RaiseTileWith(tile, 255)
				}
			}
		}
	}		
}

function RailwAI::makeRailBridgesDoubleTrack() {
	foreach (tile in this.myTiles) {
		if (IsRailBridge(tile)) {
			local otherTile = AIBridge.GetOtherBridgeEnd(tile);
			local length = AIMap.DistanceManhattan(tile, otherTile)
			local delta = (tile-otherTile)/length
			local delta2 = (otherTile-tile)/length
			if (length < 7 || !IsFlatTile(tile+delta) || !IsFlatTile(otherTile-delta))
				continue
			if (IsRailTunnelBridge(tile + dXY(0,1)) || IsRailTunnelBridge(tile + dXY(0,-1)) || IsRailTunnelBridge(tile + dXY(1,0)) || IsRailTunnelBridge(tile + dXY(-1,0)))
				continue
			local perp = getPerp(delta)
			if (!AITile.IsBuildable(tile+delta+perp) || !AITile.IsBuildable(otherTile-delta+perp))
				continue
			local bridgeType = AIBridge.GetBridgeID(tile)
			AIRail.SetCurrentRailType(AIRail.GetRailType(tile))
			
			if (AIBridge.BuildBridge(AIVehicle.VT_RAIL, bridgeType, tile+perp, otherTile+perp)) {
				LogTile("Building bridge1", tile+perp)
				LogTile("Building bridge2", otherTile+perp)
				this.ConnectRailBridgeEnd(tile+perp)
				this.ConnectRailBridgeEnd(otherTile+perp)
				/*ConnectRailTile(tile+delta+perp)
				ConnectRailTile(otherTile-delta+perp)*/
			}
		}
	}
}

function RailwAI::BuildRandomRailTunnels() {
	//return //too soon
	foreach (tile in this.myTiles) {
		if (AIRail.IsRailTile(tile)) {
			local tracks = AIRail.GetRailTracks(tile)
			local delta = 0
			local sideways = 0
			local slope = AITile.GetSlope(tile)
			if (tracks == AIRail.RAILTRACK_NE_SW) {
				//if (slope == AITile.SLOPE_FLAT || slope == AITile.SLOPE_SW)
				if (slope == AITile.SLOPE_SW) {
					delta = dXY(1,0)
					sideways = dXY(0,1)
				} else if (slope == AITile.SLOPE_NE) {
					delta = dXY(-1,0)
					sideways = dXY(0,1)
				}
			} else if (tracks == AIRail.RAILTRACK_NW_SE) {
				//if (slope == AITile.SLOPE_FLAT || slope == AITile.SLOPE_SE)
				if (slope == AITile.SLOPE_SE) {
					delta = dXY(0,1)
					sideways = dXY(1,0)
				} else if (slope == AITile.SLOPE_NW) {
					delta = dXY(0,-1)
					sideways = dXY(1,0)
				}
			}
			if (delta != 0 && !AITunnel.IsTunnelTile(tile-delta) && !this.failedTiles.HasItem(tile)) {
				local tileHeight = AITile.GetMaxHeight(tile)
				local t = tile
				local length = 0
				local nextToOtherTunnel = AITunnel.IsTunnelTile(tile+sideways) || AITunnel.IsTunnelTile(tile-sideways)
				for (local i = 0; i < 8; i++) {
					t += delta
					local UnusableTile = AIRail.IsRailStationTile(t) || AIRail.IsRailDepotTile(t) || AIRail.IsLevelCrossingTile(t)
					if (AITile.GetMinHeight(t) >= tileHeight && AIRail.GetRailTracks(t) == tracks && !UnusableTile) {
						length++
						if (i > 1 && AITile.GetSlope(t-delta) == AITile.SLOPE_FLAT && AITile.GetSlope(t) == AITile.SLOPE_FLAT &&
							AITile.GetMinHeight(t) == tileHeight && !nextToOtherTunnel) {
							if (i > 4 || AITile.GetSlope(t+delta) != AITile.SLOPE_FLAT || AIRail.GetRailTracks(t+delta) != tracks) {
								//valid tunnel end
								LogTile("Building rail tunnel at", tile, "tunnel")
								AIRail.SetCurrentRailType(AIRail.GetRailType(tile))
								local succes = false
								//if (AIRail.RemoveRail(tile-delta,tile,t+delta)) {
								if (RemoveStraightRail(tile-delta,tile,t+delta)) {
									LogTile("lowering" + slope, t-delta, "tunnel")
									
									//if (LowerTileWith(t-delta,slope) && AITunnel.BuildTunnel(AIVehicle.VT_RAIL, t-delta)) {
									if (AITile.LowerTile(t-delta,slope) && AITunnel.GetOtherTunnelEnd(t-delta) == tile && AITunnel.BuildTunnel(AIVehicle.VT_RAIL, t-delta)) {
										succes = true
											LogTile("succesful tunnel built", t-delta)
										AIRail.BuildRail(t-delta, t, t+delta)
										local signalDirection = GetRailSignalDirection(t, t-delta)
										if (signalDirection == 1) {
											if (!HasRailSignal(t)) AIRail.BuildSignal(t, t-delta, AIRail.SIGNALTYPE_PBS)
											if (!HasRailSignal(tile)) AIRail.BuildSignal(tile, tile-delta, AIRail.SIGNALTYPE_NORMAL)
										} else if (signalDirection == -1) {
											if (!HasRailSignal(t)) AIRail.BuildSignal(t, t+delta, AIRail.SIGNALTYPE_NORMAL)
											if (!HasRailSignal(tile-delta)) AIRail.BuildSignal(tile-delta, tile, AIRail.SIGNALTYPE_PBS)
										}
									}
								}
								if (!succes) {
									Log("failed. rebuilding")
									//AIRail.BuildRail(tile-delta,tile,t+delta) //rebuild
									RebuildStraightRail(tile-delta,tile,t+delta) //rebuild
									this.failedTiles.AddItem(tile, 0)
									local signalDirection = GetRailSignalDirection(t, t-delta)
									if (signalDirection == 1) {
										if (!HasRailSignal(t)) AIRail.BuildSignal(t, t-delta, AIRail.SIGNALTYPE_PBS);
										if (!HasRailSignal(tile)) AIRail.BuildSignal(tile, tile-delta, AIRail.SIGNALTYPE_NORMAL);
									} else if (signalDirection == -1) {
										if (!HasRailSignal(t)) AIRail.BuildSignal(t, t+delta, AIRail.SIGNALTYPE_NORMAL);
										if (!HasRailSignal(tile-delta)) AIRail.BuildSignal(tile-delta, tile, AIRail.SIGNALTYPE_PBS);
									}
								}
								i = 999
							}
						}
					} else if (AITile.GetMaxHeight(t) == tileHeight && AIRail.GetRailTracks(t) == tracks && i >= 1 && !UnusableTile) {//tunnel end
						t += delta
						LogTile("Building rail tunnel at", tile, "tunnel")
						LogTile("Building rail tunnel at", t-delta, "tunnel")
						AIRail.SetCurrentRailType(AIRail.GetRailType(tile))
						local succes = false
						//if (AIRail.RemoveRail(tile-delta,tile,t+delta)) {
						if (RemoveStraightRail(tile-delta,tile,t+delta)) {
							LowerTileWith(t-delta,slope)
							if (AITunnel.GetOtherTunnelEnd(t-delta) == tile && AITunnel.BuildTunnel(AIVehicle.VT_RAIL, t-delta)) {
								succes = true
								LogTile("succesful tunnel2", t-delta)
								AIRail.BuildRail(t-delta, t, t+delta)
								local signalDirection = GetRailSignalDirection(t, t-delta)
								if (signalDirection == 1) {
									if (!HasRailSignal(t)) AIRail.BuildSignal(t, t-delta, AIRail.SIGNALTYPE_PBS)
									local f = GetNextRailTile(tile-delta, tile)
									if (f && !HasRailSignal(tile-delta)) {
										AIRail.BuildSignal(tile-delta, f, AIRail.SIGNALTYPE_NORMAL)
									}
								} else if (signalDirection == -1) {
									if (!HasRailSignal(t)) AIRail.BuildSignal(t, t+delta, AIRail.SIGNALTYPE_NORMAL)
									if (!HasRailSignal(tile-delta)) AIRail.BuildSignal(tile-delta, tile, AIRail.SIGNALTYPE_PBS)
								}
							}
						}
						if (!succes) {
							Log("failed. rebuilding2")
							//AIRail.BuildRail(tile-delta,tile,t) //rebuild
							//AIRail.BuildRail(t-delta, t, t+delta) //try to build anyway
							RebuildStraightRail(tile-delta,tile,t+delta) //rebuild
							this.failedTiles.AddItem(tile, 0)
							local signalDirection = GetRailSignalDirection(t, t-delta)
							if (signalDirection == 1) {
								if (!HasRailSignal(t)) AIRail.BuildSignal(t, t-delta, AIRail.SIGNALTYPE_PBS);
								if (!HasRailSignal(tile)) AIRail.BuildSignal(tile, tile-delta, AIRail.SIGNALTYPE_NORMAL);
							} else if (signalDirection == -1) {
								if (!HasRailSignal(t)) AIRail.BuildSignal(t, t+delta, AIRail.SIGNALTYPE_NORMAL);
								if (!HasRailSignal(tile-delta)) AIRail.BuildSignal(tile-delta, tile, AIRail.SIGNALTYPE_PBS);
							}
						}
						i = 999
					} else {
						length = 0
						i = 999
					}
				}
				if (!MayDoExpensiveStuff()) return
			}
		}
	}
}

function RailwAI::PlantSomeTrees() {
	for (local j = 0; j < RailwAI.GetSetting("plant_trees"); j++) {
		local i = (2+AIBase.RandRange(5))*(1+AIBase.RandRange(10))
		local location = AIBase.RandRange(AIMap.GetMapSize())
		while (AITile.GetMaxHeight(location) == 0)
			location = AIBase.RandRange(AIMap.GetMapSize())
		LogTile("Planting " + i + " trees around ", location, "tree")
		for (;i > 0; i--)
			AITile.PlantTree(location + dXY(AIBase.RandRange(6)+AIBase.RandRange(4)-5, AIBase.RandRange(4)+AIBase.RandRange(6)-5))
	}
}

function RailwAI::BuildStatue() {
	for (local i = 0; i < 10; i++) { //maximum 10 attempts
		local list = AIStationList(AIStation.STATION_ANY)
		list.RemoveTop(AIBase.RandRange(list.Count()))
		local station = list.Begin()
		local town = AITile.GetClosestTown(AIStation.GetLocation(station))
		if (!AITown.HasStatue(town) && AITown.IsActionAvailable(town, AITown.TOWN_ACTION_BUILD_STATUE)) {
			if (AITown.PerformTownAction(town, AITown.TOWN_ACTION_BUILD_STATUE))
				return true
		}
	}
	return false
}

function RailwAI::DoSomethingExpensive() {
	if (AIBase.RandRange(10) < 5)
		this.BuildStatue()
	else
		this.PlantSomeTrees()
	if (!MayDoExpensiveStuff()) return
	makeRailBridgesDoubleTrack()
	if (!MayDoExpensiveStuff()) return
	BuildRandomRailTunnels()
	if (!MayDoExpensiveStuff()) return
	RaiseLandOfRailSlopes()
}