class RailwAI extends AIInfo {
	function GetAuthor()         { return "Railway master"; }
	function GetName()           { return "RailwAI"; }
	function GetDescription()    { return "An AI that builds railway lines with a mix of trains, uses buses, trams, trucks and ships."; }
	function GetVersion()        { return 15; }
	function MinVersionToLoad()  { return 3; }
	function GetDate()           { return "2019-02-28"; }
	function CreateInstance()    { return "RailwAI"; }
	function GetShortName()      { return "Rwai"; }
	function GetAPIVersion()     { return "1.0"; }
	function UseAsRandomAI()     { return true; }
	function GetURL()            { return "https://www.tt-forums.net/viewtopic.php?f=65&t=83545&p=1210341"; }
	function GetSettings() {
		AddSetting({name = "use_trains", 
			description = "Use trains", 
			easy_value = 1, 
			medium_value = 1, 
			hard_value = 1, 
			custom_value = 1, 
			flags = AICONFIG_BOOLEAN});
		AddSetting({name = "use_road", 
			description = "Use road vehicles", 
			easy_value = 1, 
			medium_value = 1, 
			hard_value = 1, 
			custom_value = 1, 
			flags = AICONFIG_BOOLEAN});
		AddSetting({name = "use_trams", 
			description = "Use trams, not only buses and trucks", 
			easy_value = 1, 
			medium_value = 1, 
			hard_value = 1, 
			custom_value = 1, 
			flags = AICONFIG_BOOLEAN});
		AddSetting({name = "use_ships", 
			description = "Use ships", 
			easy_value = 1, 
			medium_value = 1, 
			hard_value = 1, 
			custom_value = 1, 
			flags = AICONFIG_BOOLEAN});
			
		AddSetting({name = "use_pass", 
			description = "Transport passengers", 
			easy_value = 1, 
			medium_value = 1, 
			hard_value = 1, 
			custom_value = 1, 
			flags = AICONFIG_BOOLEAN});
		AddSetting({name = "use_cargo", 
			description = "Transport cargo", 
			easy_value = 1, 
			medium_value = 1, 
			hard_value = 1, 
			custom_value = 1, 
			flags = AICONFIG_BOOLEAN});


		AddSetting({name = "plant_trees", 
			description = "Plant more trees, when the company is profitable", 
			easy_value = 4, 
			medium_value = 2, 
			hard_value = 1, 
			custom_value = 2, 
			flags = 0, 
			min_value = 0, 
			max_value = 10});    	
	}
}

/* Tell the core we are an AI */
RegisterAI(RailwAI());