const FILTER = 0

function LogTile(tag, tile, filter = null) {
	if (filter != FILTER && FILTER != 0) return
	if (tile == null)
		AILog.Info(tag + " null tile!")
	else
		AILog.Info(tag + " (" + AIMap.GetTileX(tile) + "," + AIMap.GetTileY(tile) + ")");
}
function LogTiles(tag, tile, tag2, tile2, filter = null) {
	if (filter != FILTER && FILTER != 0) return
	if (tile == null || tile2 == null)
		AILog.Info(tag + " null tile!")
	else
		AILog.Info(tag + " (" + AIMap.GetTileX(tile) + "," + AIMap.GetTileY(tile) + ")" +
		tag2 + " (" + AIMap.GetTileX(tile2) + "," + AIMap.GetTileY(tile2) + ")");
}

function Log(text, filter = null) {
	if (filter != FILTER && FILTER != 0) return
	AILog.Info(text + "");
}
function LogWarning(text, filter = null) {
	if (filter != FILTER && FILTER != 0) return
	AILog.Warning(text + "");
}
function LogError(text, filter = null) {
	if (filter != FILTER && FILTER != 0) return
	AILog.Error(text + "");
}