/*
 * This file is part of TutorialShipAI, which is an AI for OpenTTD
 * Copyright (C) 2012  Leif Linse & William Minchin
 *
 * TutorialShipAI is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * TutorialShipAI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TutorialShipAI; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/*
 * Most of the ShipAI was written by William Minchin (MinchinWeb).
 * Leif Linse (Zuu) only created the basic structure and communication
 * with Basic Tutorial.
 */

SELF_VERSION <- 17;

class MainClass extends AIInfo {
	function GetAuthor()      { return "Zuu"; }
	function GetName()        { return "TutorialShipAI"; }
	function GetShortName()   { return "TSHP"; }
	function GetDescription() { return "Tutorial Ship AI"; }
	function GetAPIVersion()  { return "1.2"; }
	function GetVersion()     { return SELF_VERSION; }
	function MinVersionToLoad() { return 1; }
	function GetDate()        { return "2013-04-03"; }
	function GetUrl()         { return ""; }
	function UseAsRandomAI()  { return false; }
	function CreateInstance() { return "MainClass"; }
	function IsDeveloperOnly() { return true; }

	function GetSettings() {
		// SuperLib will use log level 3 for values >= 3 while MetaLib will use all values from 1 to 7.
		AddSetting({name = "Debug_Level", description = "Debug: Log level (higher = print more)", easy_value = 3, medium_value = 3, hard_value = 3, custom_value = 3, flags = AICONFIG_INGAME, min_value = 1, max_value = 7});
	}
}

/* Tell the core we are an AI */
RegisterAI(MainClass());

